/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;

public abstract class Scrollable extends Control {
	ScrollBar horizontalBar, verticalBar;

Scrollable () {
}
	
public Scrollable (Composite parent, int style) {
	super (parent, style);
}

public Rectangle computeTrim (int x, int y, int width, int height) {
	checkWidget ();
	return _computeTrim (x, y, width, height);
}

ScrollBar createScrollBar (int type) {
	ScrollBar bar = new ScrollBar (this, type);
	if ((state & CANVAS) != 0) {
		bar.setValues(0, 0, 100, 10, 1, 10);
	}
	return bar;
}

void createWidget (Display display, Widget parent, int style, int index) {
	super.createWidget (display, parent, style, index);
	if ((style & SWT.H_SCROLL) != 0) horizontalBar = createScrollBar (SWT.H_SCROLL);
	if ((style & SWT.V_SCROLL) != 0) verticalBar = createScrollBar (SWT.V_SCROLL);
}

public Rectangle getClientArea () {
	checkWidget ();
	Rectangle rectangle = new Rectangle(0,0,0,0);
	this._getClientArea(rectangle);
	return rectangle;
}

public ScrollBar getHorizontalBar () {
	checkWidget ();
	return horizontalBar;
}

public ScrollBar getVerticalBar () {
	checkWidget ();
	return verticalBar;
}

void releaseChildren (boolean destroy) {
	if (horizontalBar != null) {
		horizontalBar.release (false);
		horizontalBar = null;
	}
	if (verticalBar != null) {
		verticalBar.release (false);
		verticalBar = null;
	}
	super.releaseChildren (destroy);
}

/*---------------- NATIVE INTERFACE ----------------*/

Rectangle _computeTrim (int x, int y, int width, int height) {
//TODO figure out how to compute the real trim	
//TODO find the native width/height of the system/browser - not hard coded	
	if ((style & SWT.V_SCROLL) != 0) {
		width += 17;
	}
	if ((style & SWT.H_SCROLL) != 0) {
		height += 17;
	}
	return new Rectangle(x+1,y+1,width+1,height+1);
}

native void _getClientArea (Rectangle rectangle) /*-{
	var self = this.@org.eclipse.swt.widgets.Widget::jsObject;
	var dim = self.containerNode ? $wnd.dojo.marginBox(self.containerNode) : $wnd.dojo.marginBox(self.domNode);
	rectangle.@org.eclipse.swt.graphics.Rectangle::x = 0;
	rectangle.@org.eclipse.swt.graphics.Rectangle::y = 0;
	rectangle.@org.eclipse.swt.graphics.Rectangle::width = dim.w;
	rectangle.@org.eclipse.swt.graphics.Rectangle::height = dim.h;
}-*/;

}
